//	ADFS_Prefs.h

#ifndef	_H_ADFS_Prefs
#define	_H_ADFS_Prefs

#include "Utils.h"
#include "CFinderWindowHeader.h"
#include "CDialogNewDisk.h"
#include "CDialogPrefs.h"

#define		kADFS_PrefsVers		9

#pragma options align = packed

typedef struct {
	Rect	windR;			//	window size and position
	ushort	arrangeBy;		//	index, name, size etc
	ushort	reversedB		: 1;
	ushort	viewAs			: 2;	//	icon, list, column...
	ushort	unused1			: 1;
	ushort	unused2			: 4;
	ushort	unused3			: 8;
	ushort	unused4[2];
	ulong	unused5[4];
	ushort	numColumns;		//	ADFS_Stat_NUMTYPES
	ushort	columnWidths[ADFS_Stat_NUMTYPES];
} ADFS_ViewPrefsRec;

#define		ADFS_kFileDataRecVers	1

typedef struct {
	ushort	version;
	ushort	unused;
	Point	icon_pos;
} ADFS_FileDataRec;

#define		kNumWindowPrefs		1
#define		kDTWindIndex		0

typedef enum {
	PREF_Wind_COPY, 
	PREF_Wind_ABOUT, 
	PREF_Wind_INFO, 
	PREF_Wind_NEW_DISK, 
	PREF_Wind_PREFS, 
	PREF_Wind_3BUTTON, 
	PREF_Wind_DISK_MAP, 
	PREF_Wind_FORMAT_DISK, 
	PREF_Wind_EXTRA1, 
	
	PREF_Wind_NUMTYPES
} PREF_WindType;

typedef struct {
	//	**WARNING this is a PREF struct
	//	it must be padded to an even size
	ushort				prefVers;
	Rect				windA[PREF_Wind_NUMTYPES];

	ushort				prefProgMenuS;				
	
	ushort				copyTwirledDown			: 1;
	ushort				loggingB				: 1;
	ushort				detokenizeB				: 1;
	ushort				redBackgroundB			: 1;
	ushort				blackAndWhiteB			: 1;
	ushort				log_updatesB			: 1;
	ushort				log_memoryB				: 1;
	ushort				show_deskB				: 1;
	ushort				unused3					: 8;
	
	ADFS_NewDiskRec		newDiskRec;
	
	//	how many windows we keepin' track of?
	ushort				numWindows;
	ADFS_ViewPrefsRec	windowPrefs[kNumWindowPrefs];
} ADFS_PrefsRec, *ADFS_PrefsPtr, **ADFS_PrefsHandle;

#pragma options align = reset

OSErr		LoadPrefs(void);
OSErr		SavePrefs(void);

extern		ADFS_PrefsHandle	gPrefsH;

#endif